'Q_decoder_pico_PIO
 
 'based on Github code
 
 'Generic defines
 '
 f= 63e6   '63 MHz (50% of 126MHz clock of PicoMiteVGA)
 setpin gp0,pio1    'the I signal
 setpin gp1,pio1    'the Q signal
 
 
 ' PIO code -------------------------------------------------------------------
 
 'header and start of the PIO code
 pio assemble 1,".program test"
 pio assemble 1,".line 0"
 
 'jump table that forms the state machine
 pio assemble 1,"JMP push_out" '00-00
 pio assemble 1,"JMP minus1"   '00-01
 pio assemble 1,"JMP plus1"    '00-10
 pio assemble 1,"JMP push_out" '00-11
 pio assemble 1,"JMP plus1"    '01-00
 pio assemble 1,"JMP push_out" '01-01
 pio assemble 1,"JMP push_out" '01-10
 pio assemble 1,"JMP minus1"   '01-11
 pio assemble 1,"JMP minus1"   '10-00
 pio assemble 1,"JMP push_out" '10-01
 pio assemble 1,"JMP push_out" '10-10
 pio assemble 1,"JMP plus1"    '10-11
 pio assemble 1,"JMP push_out" '11-00
 pio assemble 1,"JMP plus1"    '11-01
 pio assemble 1,"JMP minus1"   '11-10
 pio assemble 1,"JMP push_out" '11-11
 
 'the actual PIO code, uses Y to store previous IO state
 pio assemble 1,".wrap target" 'end of program returns here
 pio assemble 1,"delta0:"      'this is also the no-change entry
 pio assemble 1,"mov ISR,null" 'clear jump address
 pio assemble 1,"in Y, 2"      'shift 2 bits from Y into ISR
 pio assemble 1,"mov Y, pins " 'Copy 2 IO bits into Y (note "space" after pins)
 pio assemble 1,"in Y, 2"      'shift these 2 bits from Y into ISR
 pio assemble 1,"mov PC, ISR"  'jump to the address in ISR (jump table))
 
 'The plus and minus routines, X is the actual 32 bit position counter
 pio assemble 1,"minus1:"      'jump here to decrement X
 pio assemble 1,"JMP X--, push_out"  'decrement X
 pio assemble 1,"JMP push_out" 'regardless X value go to push_out
 pio assemble 1,"plus1:"       'label to increment X
 pio assemble 1,"mov X, !X"    'invert X
 pio assemble 1,"JMP X--, next1" 'decrement x
 pio assemble 1,"next1:"        'regardless X value come here
 pio assemble 1,"mov X, !X"     'invert back
 
 'send the most recent position to FIFO
 pio assemble 1,"push_out:"      'label
 pio assemble 1,"mov ISR, X"     'move X to ISR
 pio assemble 1,"push"           'push ISR into FIFO, not blocked
 
 'outer loop and end of program
 pio assemble 1,".wrap"          'end of code, jump to wrap target
 pio assemble 1,".end program"' list"

 
 'configure PIO 1 statemachine 0 (free on PicoMiteVGA)
 p0=pio(pinctrl 0,0,0,gp0)                      'gp0 is lowest IN pin (gp0,gp1))
 e0=pio(execctrl gp0,pio(.wrap target),pio(.wrap))         'wrap and wrap target
 s0=pio(shiftctrl 0,0,0,0,0,0)        'shift IN direction is left (the 5'th '0')

 
 'initialize PIO 1 state machine 0
 pio init machine 1,0,f,p0,e0,s0,0      'init machine with start=0 (=jmp delta0)

 
 'start the quadrature decoder PIO 1 statemachine 0
 pio start 1,0
 

 
 'main MMBasic code -------------------------------------------------------------
 
 dim integer dat(3)     'array to store FIFO data
 dim integer posi
 'main loop
 do
   a$=inkey$                                     'just for control
   
   'get the data from the fifo
   pio read 1,0,4,dat()                         'read whole fifo
   posi=dat(3)                                  'last data in fifo
   if posi>2147483647 then inc posi,-4294967296  '2'th complement
   
   'if posi and &h80000000 then inc posi, - &hffffffff
   
   print posi                                    'show position
   
   'just some pause
   pause 100                                     'any delay needed
   
   'reset position (PIO X register) under control of keyboard
   if a$="r" then                                'press r to zero position
     pio execute 1,0,&hA023    '= assembly "mov X, null" (zero the X register)
     a$=""
   end if
   
 loop while a$=""  'exit when any key not r
 
end